function [] = vstk2stk(dir_tmp)
%Takes a directory of virtual stacks and makes them into actual Tiff stacks
%Synatax:   [] = vstk2stk(dir);
%Input:     dir = the directory where the virtual stacks are located
%Output:    none

if nargin==0
    dir_tmp = [];
end

%now lets get the directories with the files
if isempty(dir_tmp) %if no image root directory was entered
    prompt_box('title','Select Image Directory','prompt1','Open the root folder of your virtual stacks','position','center');
    pause(0.25);
    dir_tmp = uigetdir2('','Directory where the images are located');    %get the directory
end

%now grab look in the root directory to see how many directories are there
ch_dir = dir(dir_tmp);
%Here things will bifricate, if the root has directories then all the files
%in the root will be ignored, but if there are no directories in the root,
%then this will go into file deconvolution mode.
dirfile = [ch_dir.isdir];   %grab all of the isdir numbers
dirfile = max(dirfile(3:end));    %create the switch

switch dirfile
    case 1  %directory mode
        %grab the directory/file names
        dirnames = {ch_dir.name};
        dirnames = dirnames([ch_dir.isdir]);     %only the directories please
        h = waitbar(0,['Converting Directory:',dirnames{3}],'position',[10 50 275 50]);
        for j = 3:size(dirnames,2)    %go through the directories and files, except the first two again
            waitbar((j-2)/(size(dirnames,2)-2),h,['Converting directory: ',dirnames{j}]);   %update progress
            %now grab all of the files in that directory
            curr_dir = dir([dir_tmp,filesep,dirnames{j}]);  %now get the directory structure of the next level
            %truncate the first two rows which are . and ..
            file_tmp = {curr_dir.name};     %grab the names
            file_tmp = file_tmp(~[curr_dir.isdir]);     %only the filenames are taken
            %we only want .tif files
            tifloc = strfind(file_tmp,'.tif');   %find the tiff files
            tifidx = zeros(size(tifloc));     %initialize/reset
            for m = 1:size(tifloc,2)
                if isempty(tifloc{m})   %if this is not a tiff file
                    tifidx(m) = 0;  %ignore
                else
                    tifidx(m) = 1;  %keep
                end
            end
            file_tmp = file_tmp(logical(tifidx));   %remove non-tif files
            
            h2 = waitbar(0,['Reading Files:',file_tmp{1}]);
            for k = 1:size(file_tmp,2)  %go through the files
                curr_vstk(:,:,k) = imread([dir_tmp,filesep,dirnames{j},filesep,file_tmp{k}])';
                waitbar(k/size(file_tmp,2),h2,['Reading Files: ',file_tmp{k}]);   %update progress
            end
            close(h2)
            %save stack
            sav2stk(curr_vstk,file_tmp{k},[dir_tmp,filesep]);
        end
        close(h)
otherwise   %file mode
    %grab the directory/file names
    file_tmp = {ch_dir.name};
    file_tmp = file_tmp(~[ch_dir.isdir]);     %only the filenames are taken
    %we only want .tif files
    tifloc = strfind(file_tmp,'.tif');   %find the tiff files
    tifidx = zeros(size(tifloc));     %initialize/reset
    for m = 1:size(tifloc,2)
        if isempty(tifloc{m})   %if this is not a tiff file
            tifidx(m) = 0;  %ignore
        else
            tifidx(m) = 1;  %keep
        end
    end
    file_tmp = file_tmp(logical(tifidx));   %remove non-tif files
    %now go through the files
    h2 = waitbar(0,['Reading Files:',file_tmp{1}]);
    for j = 1:size(file_tmp,2)
        curr_vstk(:,:,j) = imread([dir_tmp,filesep,file_tmp{j}])';
        waitbar(j/size(file_tmp,2),h2,['Reading Files: ',file_tmp{j}]);   %update progress
    end
    close(h2)
    sav2stk(curr_vstk,file_tmp{j},[dir_tmp,filesep]);
end